\name{plotROC}
\alias{plotROC}
\title{Create ROC plot }
\description{
Create receiver operating characteristic (ROC) plot at various threshold settings.
}
\usage{
plotROC(seqs, score, group, label, refGroup, title, legTitle)
}
\arguments{
  \item{seqs}{Sequin names}
  \item{score}{How to rank ROC points}
  \item{group}{How to group ROC points}
  \item{label}{True-positive (TP) or false positive (FP)}  
  \item{refGroup}{Reference ratio groups}
  \item{title}{Label of the plot. Default to \code{NULL}.}
  \item{legTitle}{Title of the legend. Default to \code{Ratio}.}
}
\details{
Create a receiver operating characteristic (ROC) plot at various threshold
settings. The true positive rate (TPR) is plotted on the x-axis and false
positive rate (FPR) is plotted on the y-axis.

The function requires a scoring threshold function, and illustrates the
performance of the data as the threshold is varied. Common scoring threshold
include p-value, sequencing depth and allele frequency, etc. 

ROC plot is a useful diagnostic performance tool; it provides tools to select
possibly optimal models and to discard suboptimal ones. In particularly, the
AUC statistics indicate the performance of the model relatively to a random
experiment (AUC 0.5). 
}
\value{
The function prints ROC plot and return it's AUC statistics.
}
\examples{
library(Anaquin)

#
# Data set generated by DESeq2 and Anaquin. described in Section 5.6.3.3 of
# the user guide.
#
data(UserGuideData_5.6.3)

# Sequin names
seqs <- row.names(UserGuideData_5.6.3)

# Expected log-fold
group <- abs(UserGuideData_5.6.3$ExpLFC)

# How the ROC curves are ranked
score <- 1-UserGuideData_5.6.3$Pval

# Classified labels (TP/FP)
label <- UserGuideData_5.6.3$Label

plotROC(seqs, score, group, label, title='ROC Plot', refGroup=0)
}

\author{Ted Wong \email{t.wong@garvan.org.au}}