% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BASiCS_PlotOffset.R
\name{BASiCS_PlotOffset}
\alias{BASiCS_PlotOffset}
\title{Visualise global offset in mean expression between two chains.}
\usage{
BASiCS_PlotOffset(
  Chain1,
  Chain2,
  Type = c("offset estimate", "before-after", "MAPlot"),
  GroupLabel1 = "Group 1",
  GroupLabel2 = "Group 2"
)
}
\arguments{
\item{Chain1, Chain2}{\linkS4class{BASiCS_Chain} objects to be plotted.}

\item{Type}{The type of plot generated.
\code{"offset estimate"} produces a boxplot of the offset alongside
an estimate of the global offset.
\code{"before-after"} produces MA plots of Mean expression against
log2(fold-change) before and after offset correction.
\code{"MA plot"} produces an MA plot of Mean expression against
log2(fold-change).}

\item{GroupLabel1, GroupLabel2}{Labels for Chain1 and Chain2 in the resulting
plot(s).}
}
\value{
Plot objects.
}
\description{
Visualise global offset in mean expression between two
\code{BASiCS_Chain} objects.
}
\examples{

# Loading two 'BASiCS_Chain' objects (obtained using 'BASiCS_MCMC')
data("ChainSC")
data("ChainRNA")

BASiCS_PlotOffset(ChainSC, ChainRNA)

}
\author{
Catalina A. Vallejos \email{cnvallej@uc.cl}

Nils Eling \email{eling@ebi.ac.uk}

Alan O'Callaghan
}
