% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_DivideAndConquer.R
\name{.generateSubsets}
\alias{.generateSubsets}
\title{Generate balanced subsets for divide and conquer BASiCS}
\usage{
.generateSubsets(
  Data,
  NSubsets,
  SubsetBy = c("cell", "gene"),
  EtaSqThreshold = 0.06,
  WithSpikes = FALSE,
  MaxDepth = 20,
  .Depth = 1
)
}
\arguments{
\item{Data}{a SingleCellExperiment object}

\item{NSubsets}{Integer specifying the number of batches into which to
divide Data for divide and conquer inference.}

\item{SubsetBy}{Partition by "cell" or by "gene".}

\item{EtaSqThreshold}{eta-squared threshold for testing of balanced partitions}

\item{WithSpikes}{Similar to argument for BASiCS_MCMC - do the Data contain
spikes?}

\item{MaxDepth}{Maximum number of recursive}

\item{.Depth}{Internal parameter. Do not set.}
}
\value{
A list of SingleCellExperiment objects
}
\description{
Partitions data based on either cells or genes. Attempts to find a
partitioning scheme which is "balanced" for either total reads per cell
across all genes (partitioning by gene)
or total expression per gene across all cells (partitioning by gene).
When partitioning by cell, at least 20 cells must be in each partition
or BASiCS_MCMC will fail.
If this partitioning fails, it will continue recursively up to a maximum
number of iterations (20 by default).
}
