% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MetaAnalysis.R
\name{fisherMethod}
\alias{fisherMethod}
\title{Fisher's method for meta-analysis}
\usage{
fisherMethod(x)
}
\arguments{
\item{x}{is an array of independent p-values}
}
\value{
combined p-value
}
\description{
Combine independent p-values using the minus log product
}
\details{
Considering a set of \emph{m} independent significance tests, the resulted 
p-values are independent and uniformly distributed between \emph{0} and 
\emph{1} under the null hypothesis. Fisher's method uses the minus 
log product of the p-values as the summary statistic, which follows a 
chi-square distribution with \emph{2m} degrees of freedom. 
This chi-square distribution is used to calculate the combined p-value.
}
\examples{

x <- rep(0,10)
fisherMethod(x)

x <- runif(10)
fisherMethod(x)

}
\author{
Tin Nguyen and Sorin Draghici
}
\references{
[1] R. A. Fisher. Statistical methods for research workers. 
Oliver & Boyd, Edinburgh, 1925.
}
\seealso{
\code{\link{stoufferMethod}}, \code{\link{addCLT}}
}

