% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/volcano_plot.R
\name{volcano_plot}
\alias{volcano_plot}
\title{Volcano plot}
\usage{
volcano_plot(DE_results, pslider = 0.05, fcslider)
}
\arguments{
\item{DE_results}{a dataframe with the results of one of the DE Analysis;
must include "log2FoldChange" and "pvalue" columns}

\item{pslider}{Magnitude of significance value threshold, default is 0.05}

\item{fcslider}{Magnitude of expression change value threshold}
}
\value{
A volcano plot of expression change and significance value data
}
\description{
This function allows you to plot DE analysis results as a volcano plot
}
\examples{
library(scran)
se <- mockSCE()
differential_expression <- BatchQC::DE_analyze(se = se,
                                                method = "DESeq2",
                                                batch = "Treatment",
                                                conditions = c(
                                                "Mutation_Status",
                                                "Cell_Cycle"),
                                                assay_to_analyze = "counts",
                                                padj_method = "BH")
value <- round((max(abs(
    differential_expression[[length(differential_expression)]][, 1]))
    + min(abs(
    differential_expression[[length(differential_expression)]][, 1]))) / 2)

volcano_plot(differential_expression[[1]], pslider = 0.05, fcslider = value)
}
