% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formatData.R
\name{formatData}
\alias{formatData}
\title{Format RNA-seq or Affymetrix data downloaded from Bgee.}
\usage{
formatData(myBgeeObject, data, stats = NULL, callType = "all")
}
\arguments{
\item{myBgeeObject}{A Reference Class Bgee object, notably specifying the targeted species and data type.}

\item{data}{A list of data frames including data from multiple experiments, or a data frame including data from a single experiment.}

\item{stats}{A character indicating what expression values should be used in the formatted data expressionSet object matrix.
\itemize{
\item{"rpkm" for bulk RNA-seq (Bgee release 13.2 and before)}
\item{"fpkm" for bulk RNA-seq (Bgee release 14.0 to 14.2)}
\item{"counts" for RNA-seq}
\item{"tpm" for bulk RNA-seq or full length single cell RNA-seq (Bgee release 14 and above)}
\item{"cpm" for droplet based single cell RNA-seq (Bgee release 15.2 and above)}
\item{"intensities" for Affymetrix microarrays}
}}

\item{callType}{A character indicating whether intensities should be displayed only for present (i.e., expressed) genes, present high quality genes, or all genes (default).
\itemize{
\item{"present"}
\item{"present high quality"}
\item{"all"}
}}
}
\value{
If data was a list of data frames from multiple experiments, returns a list of ExpressionSet objects. If data was a data frame from a single experiment, returns an ExpressionSet object.
}
\description{
This function formats the data downloaded with the getSampleRawData() function into an object of the Bioconductor "expressionSet" Class.
}
\examples{
{
  bgee <- Bgee$new(species = "Mus_musculus", dataType = "rna_seq")
  dataMouseGSE43721 <- getData(bgee, experimentId = "GSE43721")
  dataMouseGSE43721.tpm <- formatData(bgee,
                                       dataMouseGSE43721,
                                       callType = "present",
                                       stats = "tpm")
}

}
\author{
Andrea Komljenovic and Julien Roux.
}
