% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSampleProcessedData.R
\name{getSampleProcessedData}
\alias{getSampleProcessedData}
\title{Retrieve Bgee processed expression values for bulk RNA-seq, full length single-cell RNA-seq,
droplet based single-cell RNA-seq or Affymetrix data.}
\usage{
getSampleProcessedData(
  myBgeeObject,
  experimentId = NULL,
  sampleId = NULL,
  anatEntityId = NULL,
  stageId = NULL,
  cellTypeId = NULL,
  sex = NULL,
  strain = NULL,
  withDescendantAnatEntities = FALSE,
  withDescendantStages = FALSE,
  withDescendantCellTypes = FALSE
)
}
\arguments{
\item{myBgeeObject}{A Reference Class Bgee object, notably specifying the targeted species
and data type.}

\item{experimentId}{Filter allowing to specify one or more ArrayExpress or GEO accession, e.g.,
GSE43721. Default is NULL: takes all available experiments for targeted species and data type.}

\item{sampleId}{Filter allowing to specify one or more sample ID. Depending on the selected
datatype this sample IDs can correspond to Chip IDs (affymetrix) or RNA-Seq library IDs (rna_seq).
Default is NULL: takes all available samples for targeted species and data type.}

\item{anatEntityId}{Filter allowing to specify one or more anatomical entity IDs from the UBERON
ontology (http://uberon.github.io/). Default is NULL: takes all available anatomical entities for
targeted species and data type.}

\item{stageId}{Filter allowing to specify one or more developmental stage IDs from Developmental
Stage Ontology (https://github.com/obophenotype/developmental-stage-ontologies). Default is
NULL: takes all available developmental stages for targeted species and data type.}

\item{cellTypeId}{Filter specific to single cell datatype (sc_full_length) allowing to specify
one or more cell type IDs from the UBERON ontology (http://uberon.github.io/). Default is
NULL: takes all available cell types for targeted species and data type. Available for Bgee 15.0 and after}

\item{sex}{Filter allowing to specify one or more sexes. Default is
NULL: takes all available sexes for targeted species and data type. Available for Bgee 15.0 and after}

\item{strain}{Filter allowing to specify one or more strains. Default is
NULL: takes all available strains for targeted species and data type. Available for Bgee 15.0 and after}

\item{withDescendantAnatEntities}{Allows to filter on the selected anatEntityId and all its descendants.
This functionality is available for Bgee 15.0 release and after}

\item{withDescendantStages}{Allows to filter on the selected stageId and all its descendants.
This functionality is available for Bgee 15.0 release and after}

\item{withDescendantCellTypes}{Allows to filter on the selected cellTypeId and all its descendants.
This functionality is available for Bgee 15.0 release and after}
}
\value{
Return a dataframe containing all Bgee processed expression data from the selected species
and datatype using specified filters with operator AND.
}
\description{
This function loads the quantitative expression data and presence calls
for samples available from Bgee. These data are available for all droplet based single-cell
RNA-seq, full length single-cell RNA-seq, bulk RNA-seq and affymetrix samples present in Bgee.
It is possible to filter the processed expression data using experiment IDs, chip IDs (affymetrix)
or library IDs (RNA-seq), anatomical entity IDs from the UBERON ontology, developmental stage IDs,
cell-type IDs, sex and/or strain. Celltype, anatomical entity and stage IDs are normalized and come from
ontologies, allowing to retrieve data annotated with the selected term or with the term and all its descendants.
This option allows for instance to retrieve all processed expression values coming from the brain or
any subpart of the brain.
}
\examples{
{
  bgee <- Bgee$new(species = "Mus_musculus", dataType = "rna_seq")
  dataMouseGSE43721 <- getSampleProcessedData(bgee, experimentId = "GSE43721")
  dataMouseVariousFilters <- getSampleProcessedData(bgee, experimentId = c("GSE43721", "GSE36026"), 
                             anatEntityId = c("UBERON:0002107", "UBERON:0000956", "UBERON:0002048"))
}

}
\author{
Julien Wollbrett, Andrea Komljenovic and Julien Roux.
}
