% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{BSFDataSet}
\alias{BSFDataSet}
\alias{BSFDataSet,}
\alias{BSFDataSet-class,}
\alias{BSFDataSetFromBigWig}
\title{BSFDataSet object and constructors}
\usage{
BSFDataSet(ranges, meta, signal, dropSeqlevels = TRUE, silent = FALSE)

BSFDataSet(ranges, meta, signal, dropSeqlevels = TRUE, silent = FALSE)

BSFDataSetFromBigWig(ranges, meta, silent = FALSE, dropSeqlevels = TRUE)
}
\arguments{
\item{ranges}{a \code{GenomicRanges} with the desired ranges to process. The
strand slot must be either + or -.}

\item{meta}{a \code{data.frame} with at least two columns. The first column
should be a unique numeric id. The second column holds sample type
information, such as the condition.}

\item{signal}{a \code{list} with the two entries 'signalPlus' and
'signalMinus', following a special representation of \code{SimpleRleList}
for counts per replicates (see details for more information).}

\item{dropSeqlevels}{enforce seqnames to be the same in ranges and signal,
by dropping unused seqlevels which is required for most downstream functions
such as \code{coverageOverRanges}}

\item{silent}{suppress messages but not warnings (TRUE/ FALSE)}
}
\value{
A BSFDataSet object.
}
\description{
\code{BSFDataSet} contains the class \code{GenomicRanges}, which is used to
store input ranges. Alongside with the iCLIP signal in \code{list} structure
and additional meta data as \code{data.frame}.
}
\details{
The ranges are enforced to have to have a "+" or "-" strand
annotation,"*" is not allowed. They are expected to be of the same width
and a warning is thrown otherwise.

The meta information is stored as \code{data.frame} with at least two
required columns, 'id' and 'condition'. They are used to build the unique
identifier for each replicate split by '_' (eg. id = 1 and condition = WT
will result in 1_WT).

The meta data needs to have the additional columns 'clPlus' and 'clMinus'
to be present if \code{BSFDataSetFromBigWig} is called.
It is used to provide the location to the iCLIP coverage
files to the import function. On object initialization these files are
loaded and internally represented in the signal slot of the object
(see \code{\link{BSFDataSet}}).

The iCLIP signal is stored in a special list structure.
At the lowest level crosslink counts per nucleotide are stored as
\code{Rle} per chromosome summarized as a \code{SimpleRleList}. Such a list
exits for each replicate and must be named by the replicate identifier
(eg. 1_WT). Therefore this list contains always exactly the same number of
entries as the number of replicates in the dataset. Since we handle strands
initially seperated from each other this list must be given twice, once
for each strand. The strand specific entries must be named 'signalPlus' and
'signalMinus'.

The option \code{dropSeqlevels} forces the seqnames of the ranges and
the signal to be the same. If for a specific chromosome in the ranges
no respective entry in the signal list can be found, then entries with
that chromosome are dropped This behavior is needed to keep the
\link{BSFDataSet} object in sync, which is required for downstream functions
such as \code{coverageOverRanges}
}
\examples{

# load data
files <- system.file("extdata", package="BindingSiteFinder")
load(list.files(files, pattern = ".rda$", full.names = TRUE))
rng = getRanges(bds)
sgn = getSignal(bds)
mta = getMeta(bds)
bdsNew = BSFDataSet(ranges = rng, signal = sgn, meta = mta)

}
