% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CoverageFunctions.R
\name{clipCoverage}
\alias{clipCoverage}
\title{Coverage function for BSFDataSet objects}
\usage{
clipCoverage(
  object,
  ranges.merge = FALSE,
  ranges.merge.method = c("sum", "mean"),
  positions.merge = FALSE,
  positions.merge.method = c("sum", "mean"),
  samples.merge = TRUE,
  samples.group = c("all", "condition"),
  samples.merge.method = c("sum", "mean"),
  out.format = c("granges", "data.frame"),
  out.format.overwrite = FALSE,
  match.rangeID = "bsID",
  quiet = FALSE
)
}
\arguments{
\item{object}{a BSFDataSet object}

\item{ranges.merge}{logical; whether to merge ranges}

\item{ranges.merge.method}{character; how to combine ranges ('sum' or 'mean')}

\item{positions.merge}{logical; whether to merge positions}

\item{positions.merge.method}{character; how to combine positions ('sum' or 'mean')}

\item{samples.merge}{logical: whether to merge samples}

\item{samples.group}{character; how samples should be grouped when combining
('all', 'condition')}

\item{samples.merge.method}{charater; how to combine positions ('sum' or 'mean')}

\item{out.format}{character; how the coverage should be returned
('data.frame' or 'granges'). Note that option 'granges' only exists if the
output coverage is of the same rows as the input ranges.}

\item{out.format.overwrite}{logical; if \code{out.format='granges'}, then
decide wheter the meta columns should be extended by the coverage information
or be overwritten}

\item{match.rangeID}{character; unique internal identifier.
Name of the meta column of the input ranges
that should be used as identifier to match the coverage back to the input
ranges. Is 'bsID' as default, since that ID exists for all binding sites
after \code{makeBindingSites} was called.}

\item{quiet}{logical; whether to print messages}
}
\value{
an object of class specified in \code{out.format}
}
\description{
Function that computes a crosslink coverage with all samples over all ranges
given in the \code{\link{BSFDataSet}}. The coverage can be summarized over
all combinations of the three dimension (samples, ranges, positions).
}
\details{
When summarizing the crosslink coverage over samples (\code{samples.merge=TRUE})
one can decide whether to summarize all samples or whether to keep conditions
separate (\code{samples.group}). This either reduces the samples dimension
to a single matrix, or a list. For a binding site set with 100 binding sites
of width=7 and 4 replicates with 2 conditions, the following options are
possible. With merging enabled and \code{samples.group='all'} the coverage of
all samples is combined. With \code{samples.group='condition'} only samples
of the same condition are grouped.

When summarizing the crosslink coverage over ranges, all ranges are combined
which reduces the ranges dimension to a single vector. This turns eg. a
binding site set of 100 binding sites with width=7 into a vector of length
100 with exactly one column. Depending on how the samples were summarized, the
result can be a single such vector, or a list.

When summarizing the crosslink coverage over positions, all positions are
combined which reduces the positions dimension to a single vector. This turns
eq. a binding site set of 100 binding sites with width=7 into a vector of
length 1 with 7 columns. Depending on how the samples were summarized, the
result can be a single such vector, or a list.

For all summarizing operations options \code{sum} and \code{mean} exists. This
allows for normalization by the eg. the number of binding sites, size of the
range, number of sample, etc..

If the resulting object does have a dimension that fits to the number of
input ranges the result can be directly attached to them. Basically extending
the \code{GRanges} object (\code{out.format}).
}
\examples{
# load data
files <- system.file("extdata", package="BindingSiteFinder")
load(list.files(files, pattern = ".rda$", full.names = TRUE))

bds = makeBindingSites(bds, bsSize = 7)
# sum of each replicate over each binding site position
c1 = clipCoverage(bds, out.format = "data.frame", positions.merge = TRUE,
 ranges.merge = FALSE, samples.merge = FALSE)
# total signal per binding site from all samples
c2 = clipCoverage(bds, out.format = "granges", positions.merge = FALSE,
 ranges.merge = TRUE, samples.merge = TRUE, samples.group = "all")
# total signal per binding site from all samples - split by condition
c3 = clipCoverage(bds, out.format = "granges", positions.merge = FALSE,
 ranges.merge = TRUE, samples.merge = TRUE, samples.group = "condition")

}
\seealso{
\code{\link{BSFDataSet}}, \code{\link{BSFind}}
}
