% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotFunction.R
\name{processingStepsFlowChart}
\alias{processingStepsFlowChart}
\title{Step-wise flowchart plot}
\usage{
processingStepsFlowChart(object, size.all = 3)
}
\arguments{
\item{object}{a \code{\link{BSFDataSet}} object}

\item{size.all}{numeric; size of all numbers}
}
\value{
a plot of type \code{\link{ggplot}}
}
\description{
An overview plot that shows all workflow functions that were executed on the
current object, with all input and output binding site numbers and major options
that were used. The function can be called at any time in the analysis. Most
optimal usage is after a full run of the wrapper function \code{\link{BSFind}}.
}
\examples{
# load clip data
files <- system.file("extdata", package="BindingSiteFinder")
load(list.files(files, pattern = ".rda$", full.names = TRUE))
load(list.files(files, pattern = ".rds$", full.names = TRUE)[1])
load(list.files(files, pattern = ".rds$", full.names = TRUE)[2])
bds = BSFind(bds, anno.genes = gns, anno.transcriptRegionList = regions,
 est.subsetChromosome = "chr22")
processingStepsFlowChart(bds)

}
\seealso{
\code{\link{BSFind}}
}
