% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotFunction.R
\name{reproducibilityFilterPlot}
\alias{reproducibilityFilterPlot}
\title{Plot to that shows the crosslink site distribution per replicate}
\usage{
reproducibilityFilterPlot(object, plotRange = 20)
}
\arguments{
\item{object}{a \code{\link{BSFDataSet}} object}

\item{plotRange}{numeric; number of crosslinks per sites that should be shown
before summing them up}
}
\value{
a plot of type \code{\link{ggplot}}
}
\description{
A diagnostic function that plots the number of crosslinks sites over the number
of crosslink in these sites and highlights the replicate specific
reproducibility cutoff that is derived from that distribution.
The function \code{\link{reproducibilityFilter}} is expected to be executed prior
to calling this plot function.
}
\examples{
# load clip data
files <- system.file("extdata", package="BindingSiteFinder")
load(list.files(files, pattern = ".rda$", full.names = TRUE))
bds = makeBindingSites(object = bds, bsSize = 9)
bds = reproducibilityFilter(bds)
reproducibilityFilterPlot(bds)

}
\seealso{
\code{\link{reproducibilityFilter}}
}
