% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/methods.R
\docType{methods}
\name{setSummary}
\alias{setSummary}
\alias{setSummary,BSFDataSet-method}
\title{Setter method for the summary slot of the BSFDataSet object}
\usage{
setSummary(object, ...)

\S4method{setSummary}{BSFDataSet}(object, summary)
}
\arguments{
\item{object}{a BSFDataSet object}

\item{...}{additional arguments}

\item{summary}{a data.frame with the summary information to be stored in
\code{BSFDataSet}}
}
\value{
an object of type \code{\link{BSFDataSet}} with updated summary info
}
\description{
The summary slot is used to track information of the filtering steps applied
in the \code{\link{makeBindingSites}} function
}
\examples{

# load data
files <- system.file("extdata", package="BindingSiteFinder")
load(list.files(files, pattern = ".rda$", full.names = TRUE))

df = data.frame(processingStep = c(1,2),
parameter = c(3,4))
bds = setSummary(bds, df)

}
\seealso{
\code{\link{BSFDataSet}}
}
