% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biocarta.R
\name{grid.biocarta}
\alias{grid.biocarta}
\alias{biocartaGrob}
\title{Draw a BioCarta pathway}
\usage{
grid.biocarta(
  pathway,
  color = NULL,
  x = unit(0.5, "npc"),
  y = unit(0.5, "npc"),
  width = NULL,
  height = NULL,
  just = "centre",
  default.units = "npc",
  name = NULL
)

biocartaGrob(
  pathway,
  color = NULL,
  x = unit(0.5, "npc"),
  y = unit(0.5, "npc"),
  width = NULL,
  height = NULL,
  just = "centre",
  default.units = "npc",
  name = NULL
)
}
\arguments{
\item{pathway}{A BioCarta pathway ID, a MSigDB ID or a \code{biocarta_pathway} object. All valid BioCarta pathway IDs are in \code{\link[=all_pathways]{all_pathways()}}.
The list of MSigDB IDs for BioCarta pathways can be found at \url{https://www.gsea-msigdb.org/gsea/msigdb/human/genesets.jsp?collection=CP:BIOCARTA}.}

\item{color}{A named vector where names should correspond to Entrez IDs.}

\item{x}{A numeric vector or unit object specifying x-location.}

\item{y}{A numeric vector or unit object specifying y-location.}

\item{width}{A numeric vector or unit object specifying width.}

\item{height}{A numeric vector or unit object specifying width.}

\item{just}{The same as in \code{\link[grid:viewport]{grid::viewport()}}.}

\item{default.units}{The same as in \code{\link[grid:viewport]{grid::viewport()}}.}

\item{name}{The same as in \code{\link[grid:viewport]{grid::viewport()}}.}
}
\value{
\code{biocartaGrob()} returns a \code{gTree} object.
}
\description{
Draw a BioCarta pathway
}
\details{
The graphics object contains a pathway image and genes highlighted on the image.

The aspect ratio of the image is kept. If one of \code{width} and \code{height} is set, the
other dimension is calculated by the aspect ratio. If both of \code{width} and \code{height}
is set or inherit from parent viewport, the width and height are automatically adjust
to let one dimension completely fill the viewport.
}
\examples{
library(grid)
grid.newpage()
grid.biocarta("h_RELAPathway")

grob = biocartaGrob("h_RELAPathway")
}
