% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diceSim.R
\name{diceSim}
\alias{diceSim}
\title{Compare pathways}
\usage{
diceSim(g1, g2)
}
\arguments{
\item{g1, g2}{A character list with the names of the proteins in each pathway.}
}
\value{
A score between 0 and 1 calculated as the double of the proteins
shared by g1 and g2 divided by the number of genes in both groups.
}
\description{
Function to estimate how much two list of genes overlap by looking
how much of the nodes are shared. Calculates the Dice similarity
}
\details{
It requires a vector of characters otherwise will return an \code{NA}.
}
\examples{
genes.id2 <- c("52", "11342", "80895", "57654", "548953", "11586", "45985")
genes.id1 <- c(
    "52", "11342", "80895", "57654", "58493", "1164", "1163",
    "4150", "2130", "159"
)
diceSim(genes.id1, genes.id2)
diceSim(genes.id2, genes.id2)
}
\seealso{
Used for \code{\link[=geneSim]{geneSim()}}, see \code{\link[=conversions]{conversions()}} help
page to transform Dice score to Jaccard score.
}
\author{
Lluís Revilla
}
