% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{exp2cor}
\alias{exp2cor}
\title{Calculate pairwise correlations between genes in a matrix}
\usage{
exp2cor(exp, cor_method = "pearson")
}
\arguments{
\item{exp}{A numeric matrix containing a gene expression matrix,
with genes in rows and samples in columns.}

\item{cor_method}{Character indicating the correlation method to use.
One of "pearson", "spearman", or "biweight". Default: "pearson".}
}
\value{
A numeric, symmetric matrix with pairwise correlations between
genes.
}
\description{
Calculate pairwise correlations between genes in a matrix
}
\examples{
# Simulate an expression matrix with 100 genes and 50 samples
exp <- matrix(
    rnorm(100 * 50, mean = 10, sd = 2),
    nrow = 100,
    dimnames = list(
        paste0("gene", seq_len(100)),
        paste0("sample", seq_len(50))
    )
)

# Calculate correlation matrix
cor_mat <- exp2cor(exp)
}
