% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uniqGenesetsByNamespace.R
\name{uniqGenesetsByNamespace}
\alias{uniqGenesetsByNamespace}
\title{Make names of gene-sets unique by namespace, and member genes of gene-sets unique}
\usage{
uniqGenesetsByNamespace(gmtList)
}
\arguments{
\item{gmtList}{A \code{GmtList} object, probably from \code{\link[BioQC]{readGmt}}. The object must have namespaces defined by \code{setNamespace}.

The function make sure that
\itemize{
  \item names of gene-sets within each namespace are unique, by merging gene-sets with duplicated names
  \item genes within each gene-set are unique, by removing duplicated genes
}

Gene-sets with duplicated names and different \code{desc} are merged, \code{desc} are made unique, and in case of multiple values, concatenated (with \code{|} as the collapse character).}
}
\value{
A \code{GmtList} object, with unique gene-sets and unique gene lists. If not already present, a new item \code{namespace} is appended to each \code{list} element in the \code{GmtList} object, recording the namespace used to make gene-sets unique. The order of the returned \code{GmtList} object is given by the unique gene-set name of the input object.
}
\description{
Make names of gene-sets unique by namespace, and member genes of gene-sets unique
}
\examples{
myGmtList <- GmtList(list(list(name="GeneSet1", desc="Namespace1", genes=LETTERS[1:3]),
  list(name="GeneSet2", desc="Namespace1", genes=rep(LETTERS[4:6],2)),
  list(name="GeneSet1", desc="Namespace1", genes=LETTERS[4:6]),
  list(name="GeneSet3", desc="Namespace2", genes=LETTERS[1:5])))
 
print(myGmtList)
myGmtList <- setNamespace(myGmtList, namespace=function(x) x$desc)
myUniqGmtList <- uniqGenesetsByNamespace(myGmtList)
print(myUniqGmtList)

}
