% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_1kg.R
\name{get_1kg}
\alias{get_1kg}
\title{interface to 1kg import}
\usage{
get_1kg(
  hl,
  retrieve_import_write = FALSE,
  path_1kg_zip = osn_1kg_path(),
  folder = tempdir(),
  cache = BiocFileCache::BiocFileCache()
)
}
\arguments{
\item{hl}{hail object}

\item{retrieve_import_write}{logical(1) if TRUE, use hl.utils.get_1kg to retrieve data, otherwise acquire
a previously written zip file, either from a cache, or, if no file found in cache, from web, followed by caching}

\item{path_1kg_zip}{character(1) path to zip of MatrixTable, defaults to `osn_1kg_path()`.}

\item{folder}{character(1) destination of 1kg.mt as retrieved using hl.utils.get_1kg, import_vcf, write}

\item{cache}{a BiocFileCache-type cache}
}
\value{
"hail.matrixtable.MatrixTable" instance
}
\description{
interface to 1kg import
}
\note{
overwrite is permitted in the import_vcf.write event
}
\examples{
hl <- hail_init()
mt <- get_1kg(hl)
mt
mt$rows()$select()$show(5L) # must use integer
annopath <- path_1kg_annotations()
tab <- hl$import_table(annopath, impute = TRUE)$key_by("Sample")
tab$describe()
tab$show(width = 100L)
}
