% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/skIPart.R
\name{skIncrPCA_h5}
\alias{skIncrPCA_h5}
\title{demo of HDF5 processing with incremental PCA/batch_size/fit_transform}
\usage{
skIncrPCA_h5(fn, dsname = "assay001", n_components, chunk.size = 10L)
}
\arguments{
\item{fn}{character(1) path to HDF5 file}

\item{dsname}{character(1) name of dataset within HDF5 file, assumed to be 2-dimensional array}

\item{n_components}{numeric(1) passed to IncrementalPCA}

\item{chunk.size}{numeric(1) passed to IncrementalPCA as batch_size}
}
\description{
demo of HDF5 processing with incremental PCA/batch_size/fit_transform
}
\note{
Here we use IncrementalPCA$fit_transform and let python take care of chunk retrieval.
\code{skIncrPartialPCA} acquires chunks from R matrix and uses IncrementalPCA$partial_fit.
}
\examples{
if (interactive()) {
 fn = system.file("hdf5/irmatt.h5", package="BiocSklearn") # 'transposed' relative to R iris
 dem = skIncrPCA_h5(fn, n_components=3L, dsname="tquants")
 dem
 head(getTransformed(dem))
}
}
