% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BSRDataModel-class.R
\name{learnParameters}
\alias{learnParameters}
\alias{learnParameters,BSRDataModel-method}
\title{Training of BulkSignalR model parameters}
\usage{
\S4method{learnParameters}{BSRDataModel}(
  obj,
  plot.folder = NULL,
  verbose = FALSE,
  n.rand.LR = 5L,
  n.rand.RT = 2L,
  with.complex = TRUE,
  max.pw.size = 400,
  min.pw.size = 5,
  min.positive = 4,
  quick = FALSE,
  null.model = c("automatic", "mixedNormal", "normal", "kernelEmpirical", "empirical",
    "stable"),
  filename = NULL,
  min.corr.LR = -1
)
}
\arguments{
\item{obj}{A BSRDatamodel without learned paramaters.}

\item{plot.folder}{A folder name for generating control plots.}

\item{verbose}{A logical activating progress messages for the user.}

\item{n.rand.LR}{The number of random expression matrices to use for
learning the ligand-receptor correlation distribution.}

\item{n.rand.RT}{The number of random expression matrices to use for
learning the receptor-target genes correlation distribution.}

\item{with.complex}{A logical indicating whether receptor co-complex
members should be included in the target genes.}

\item{max.pw.size}{Maximum pathway size to consider from the pathway
reference.}

\item{min.pw.size}{Minimum pathway size to consider from the pathway
reference.}

\item{min.positive}{Minimum number of target genes to be found in a given
pathway.}

\item{quick}{A logical indicating whether approximate parameters
for the receptor-target correlations should be used.}

\item{null.model}{The null model to use for Spearman correlation
null distributions.}

\item{filename}{Name of the output plot.}

\item{min.corr.LR}{The minimum ligand-receptor correlation required.}
}
\value{
A BSRDataModel object with trained model parameters
}
\description{
Unique entry point for training the parameters behind
BulkSignalR statistical models.
}
\details{
Estimates the model parameters that are stored in the
  slot \code{param}.

  In a reference pathway, i.e., a Reactome pathway or the genes of a
  GOBP term, the target genes are the genes coding for proteins forming a
  complex with the receptor and the genes in the pathway downstream the
  receptor, which are given as regulated by the pathway. If
  \code{with.complex} is set to \code{FALSE}, then only the regulated genes
  are considered. Participation to a complex, being regulated, and
  pathway directed topologies are defined by Reactome and KEGG pathways
  as provided by PathwayCommons.

  The \code{min.pw.size}, \code{max.pw.size}, and \code{min.positive}
  parameters should be identical to the
  values intended when searching for ligand-receptor pairs with
  \code{\link{.getCorrelatedLR}}) and  \code{\link{.checkReceptorSignaling}})
  Although the statistical distributions are rather robust, it is not
  advisable to use different parameters that could introduce unanticipated
  biases, but for saving compute time and exploring.

  The maximum pathway size is used to limit the redundancy inherent to GOBP
  and Reactome. The minimum pathway size is used to avoid overspecific,
  noninformative results.

  BulkSignalR approach relies on modeling (Spearman) correlations and
  different models of null distributions are available for this purpose
  (parameter \code{null.model}). By default, the "automatic" option is
  selected meaning that censored normal and mixed normal as well as
  an empirical model based on Gaussian kernels (R \code{density()} function)
  are compared to pick the one closest to the data. Preference is given
  to normal and then mixture of normal over the empirical version for
  comparable quality of fit. It is also to bypass the automatic selection.
  Fitting of an alpha-stable distribution is quite time consuming as the
  computation of its PDF is compute-intensive. Finally, in the automaic
  selection mode, the choice of the actual model will be done based on
  the L-R null assuming a similar shape for the R-T null (with
  different parameters though, unless \code{quick} was set to \code{TRUE}).

Note that since the introduction of the use.full.network parameter
(April 29, 2024) in the BSRInference method parameters,
the pathway sizes are always computed before potential
intersection with the observed data (use.full.network set to FALSE) for
consistency. Accordingly, the minimum and maximum pathway default values
have been raised from 5 & 200 to 5 & 400 respectively. By default,
use.full.network is set to TRUE, meaning no intersection and hence larger
pathways.
}
\examples{
data(sdc, package = "BulkSignalR")
idx <- sample(nrow(sdc), 4000)
bsrdm <- BSRDataModel(sdc[idx, c("N22","SDC17")],min.LR.found = 20)
bsrdm <- learnParameters(bsrdm, n.rand.LR = 1L,
verbose=FALSE,quick=TRUE)
}
