% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subsetBy.R
\name{subsetByComposition}
\alias{subsetByComposition}
\title{Subset by composition across samples}
\usage{
subsetByComposition(
  object,
  inputAssay = "counts",
  outputColumn = "composition",
  unexpressed = 0.1,
  genes = "geneID",
  minSamples = 1
)
}
\arguments{
\item{object}{RangedSummarizedExperiment: CAGE data quantified at CTSS,
cluster or gene-level.}

\item{inputAssay}{character: Name of assay holding input expression values.}

\item{outputColumn}{character: Name of column in rowRanges to hold
composition values.}

\item{unexpressed}{numeric: Composition will be calculated based on features
larger than this cutoff.}

\item{genes}{character: Name of column in rowData holding genes (NAs are not
allowed.)}

\item{minSamples}{numeric: Only features with composition in more than this
number of samples will be kept.}
}
\value{
RangedSummarizedExperiment with composition values added as a column
  in rowData and features with less composition than minSamples removed.
}
\description{
A convenient wrapper around calcComposition and subset.
}
\examples{
data(exampleUnidirectional)

# Annotate clusters with geneIDs:
library(TxDb.Mmusculus.UCSC.mm9.knownGene)
txdb <- TxDb.Mmusculus.UCSC.mm9.knownGene

exampleUnidirectional <- assignGeneID(exampleUnidirectional,
                                      geneModels=txdb,
                                      outputColumn='geneID')
exampleUnidirectional <- subset(exampleUnidirectional, !is.na(geneID))

# Keep only clusters more than 10\% in more than one sample:
calcComposition(exampleUnidirectional)

# Keep only clusters more than 5\% in more than 2 samples:
subsetByComposition(exampleUnidirectional, unexpressed = 0.05, minSamples=2)
}
\seealso{
Other Subsetting functions: 
\code{\link{subsetByBidirectionality}()},
\code{\link{subsetBySupport}()}

Other Calculation functions: 
\code{\link{calcBidirectionality}()},
\code{\link{calcComposition}()},
\code{\link{calcPooled}()},
\code{\link{calcShape}()},
\code{\link{calcSupport}()},
\code{\link{calcTPM}()},
\code{\link{calcTotalTags}()},
\code{\link{subsetByBidirectionality}()},
\code{\link{subsetBySupport}()}
}
\concept{Calculation functions}
\concept{Subsetting functions}
