% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/track.R
\name{trackBalance}
\alias{trackBalance}
\alias{trackBalance,GRanges-method}
\alias{trackBalance,GPos-method}
\alias{trackBalance,RangedSummarizedExperiment-method}
\title{Create Genome Browser Track of bidirectional balance scores}
\usage{
trackBalance(object, ...)

\S4method{trackBalance}{GRanges}(
  object,
  window = 199,
  plusColor = "cornflowerblue",
  minusColor = "tomato",
  balanceColor = "forestgreen",
  ...
)

\S4method{trackBalance}{GPos}(object, ...)

\S4method{trackBalance}{RangedSummarizedExperiment}(object, ...)
}
\arguments{
\item{object}{GenomicRanges or RangedSummarizedExperiment: Ranges with CTSSs
in the score column.}

\item{...}{additional arguments passed to DataTrack.}

\item{window}{integer: Width of sliding window used for calculating windowed
sums.}

\item{plusColor}{character: Color for plus-strand coverage.}

\item{minusColor}{character: Color for minus-strand coverage.}

\item{balanceColor}{character: Color for bidirectional balance.}
}
\value{
list of 3 DataTracks for upstream, downstream and balance.
}
\description{
Visualize balance scores used for detectiong of bidirectional sites. Mainly
intended as diagnostic tools for expert user.
}
\note{
Potentially consumes a large amount of memory!
}
\examples{
\dontrun{
library(Gviz)
data(exampleCTSSs)
data(exampleBidirectional)

# Calculate pooled CTSSs
exampleCTSSs <- calcTPM(exampleCTSSs, totalTags='totalTags')
exampleCTSSs <- calcPooled(exampleCTSSs)

# Find a bidirectional cluster to plot:
BC <- rowRanges(exampleBidirectional[10,])
start(BC) <- start(BC) - 250
end(BC) <- end(BC) + 250
subsetOfCTSSs <- subsetByOverlaps(exampleCTSSs, BC)

# Build balance track
balance_track <- trackBalance(subsetOfCTSSs)

# Plot
plotTracks(balance_track, from=start(BC), to=end(BC),
           chromosome=seqnames(BC))
}
}
\seealso{
Other Genome Browser functions: 
\code{\link{trackCTSS}()},
\code{\link{trackClusters}()},
\code{\link{trackLinks}()}
}
\concept{Genome Browser functions}
