% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trimTo.R
\name{trimToPercentiles}
\alias{trimToPercentiles}
\alias{trimToPercentiles,GRanges,GRanges-method}
\alias{trimToPercentiles,GRanges,GPos-method}
\alias{trimToPercentiles,RangedSummarizedExperiment,GenomicRanges-method}
\alias{trimToPercentiles,GRanges,RangedSummarizedExperiment-method}
\alias{trimToPercentiles,RangedSummarizedExperiment,RangedSummarizedExperiment-method}
\title{Trim width of TCs to expression percentiles}
\usage{
trimToPercentiles(object, pooled, ...)

\S4method{trimToPercentiles}{GRanges,GRanges}(object, pooled, percentile = 0.1, symmetric = FALSE)

\S4method{trimToPercentiles}{GRanges,GPos}(object, pooled, ...)

\S4method{trimToPercentiles}{RangedSummarizedExperiment,GenomicRanges}(object, pooled, ...)

\S4method{trimToPercentiles}{GRanges,RangedSummarizedExperiment}(object, pooled, ...)

\S4method{trimToPercentiles}{RangedSummarizedExperiment,RangedSummarizedExperiment}(object, pooled, ...)
}
\arguments{
\item{object}{GenomicRanges or RangedSummarizedExperiment: TCs to be trimmed.}

\item{pooled}{GenomicRanges or RangedSummarizedExperiment: CTSS coverage.}

\item{...}{additional arguments passed to methods.}

\item{percentile}{numeric: Fraction of expression to remove from TCs.}

\item{symmetric}{logical: Whether to trim the same amount from both edges of
the TC (TRUE) or always trim from the least expressed end (FALSE).}
}
\value{
GRanges with trimmed TCs, including recalculated peaks and scores.
}
\description{
Given a set of TCs and genome-wide CTSS coverage, reduce the width of TC
until a certain amount of expression has been removed.
}
\examples{
data(exampleCTSSs)
data(exampleBidirectional)

# Calculate pooled CTSSs
exampleCTSSs <- calcTPM(exampleCTSSs, totalTags='totalTags')
exampleCTSSs <- calcPooled(exampleCTSSs)

# Choose a few wide clusters:
TCs <- subset(exampleUnidirectional, width >= 100)

# Symmetric trimming (same percentage from each side):
TCs_sym <- trimToPercentiles(TCs, pooled=exampleCTSSs, symmetric=FALSE)

# Assymmetric trimming (always trim from lowest side):
TCs_asym <- trimToPercentiles(TCs, pooled=exampleCTSSs, symmetric=TRUE)

# Compare the two results sets of widths:
summary(width(TCs_sym) - width(TCs_asym))
}
\seealso{
Other Clustering functions: 
\code{\link{clusterBidirectionally}()},
\code{\link{clusterUnidirectionally}()},
\code{\link{trimToPeak}()},
\code{\link{tuneTagClustering}()}

Other Trimming functions: 
\code{\link{trimToPeak}()}
}
\concept{Clustering functions}
\concept{Trimming functions}
