% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{utilsDeStrand}
\alias{utilsDeStrand}
\title{Utility: Split Genomic Ranges by strand}
\usage{
utilsDeStrand(object)
}
\arguments{
\item{object}{Any object with a split and strand method, e.g. GRanges/GPos}
}
\value{
Object split by strand, e.g. GRangesList.
}
\description{
Utility function that attemps to split genomic ranges by strand with split(object, strand(object))
}
\examples{
gp <- GPos(seqnames=Rle(c("chr1", "chr2", "chr1"), c(10, 6, 4)),
            pos=c(44:53, 5:10, 2:5),
            strand=c(rep("+", 10), rep("-", 10)))
gr <- as(gp, "GRanges")
utilsDeStrand(gp)
utilsDeStrand(gr)
}
\seealso{
Other Utility functions: 
\code{\link{utilsAggregateRows}()},
\code{\link{utilsScoreOverlaps}()},
\code{\link{utilsSimplifyTxDb}()}
}
\concept{Utility functions}
