% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing.R
\name{fix_clonal_genotype}
\alias{fix_clonal_genotype}
\title{Manage Clonal genotype in data}
\usage{
fix_clonal_genotype(samples, freqs, labels, matching_samples)
}
\arguments{
\item{samples}{input dataset (mutational matrix) as matrix}

\item{freqs}{genotype frequencies (in the rows' order)}

\item{labels}{list of gene names (in the columns' order)}

\item{matching_samples}{list of sample names matching each genotype}
}
\value{
a named list containing the fixed "samples", "freqs" and "labels"
}
\description{
Fix the absence of the clonal genotype in the data (if needed)
}
\examples{
require(dplyr) 

# compact
compactedDataset <- compact_dataset(example_dataset())
samples <- compactedDataset$matrix

# save genes' names
genes <- colnames(compactedDataset$matrix)

# keep the information on frequencies for further analysis
freqs <- compactedDataset$counts/sum(compactedDataset$counts)

# prepare node labels listing the mutated genes for each node
labels <- prepare_labels(samples, genes)
if( is.null(compactedDataset$row_names) ){
  compactedDataset$row_names <- rownames(compactedDataset$matrix)
}
matching_samples <- compactedDataset$row_names
# matching_samples
matching_samples 

# fix Colonal genotype absence, if needed
fix <- fix_clonal_genotype(samples, freqs, labels, matching_samples)

}
