% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uniqueREs.R
\name{uniqueREs}
\alias{uniqueREs}
\title{Output restriction enzymes that recognize only the gRNA cleavage sites}
\usage{
uniqueREs(
  REcutDetails,
  summary,
  offTargets,
  scanUpstream = 100,
  scanDownstream = 100,
  BSgenomeName
)
}
\arguments{
\item{REcutDetails}{REcutDetails stored in the REcutDetails.xls}

\item{summary}{summary stored in the summary.xls}

\item{offTargets}{offTargets stored in the offTargets.xls}

\item{scanUpstream}{upstream offset from the gRNA start, default 100}

\item{scanDownstream}{downstream offset from the gRNA end, default 100}

\item{BSgenomeName}{BSgenome object. Please refer to available.genomes in
BSgenome package. For example, 
\itemize{
 \item BSgenome.Hsapiens.UCSC.hg19 - for hg19
 \item BSgenome.Mmusculus.UCSC.mm10 - for mm10
 \item BSgenome.Celegans.UCSC.ce6 - for ce6
 \item BSgenome.Rnorvegicus.UCSC.rn5 - for rn5
 \item BSgenome.Drerio.UCSC.danRer7 - for Zv9
 \item BSgenome.Dmelanogaster.UCSC.dm3 - for dm3
}}
}
\value{
returns the RE sites that recognize only the gRNA cleavage sites for
each gRNA.
}
\description{
For each identified gRNA, output restriction enzymes that recognize only the
gRNA cleavage sites.
}
\examples{

    library("BSgenome.Hsapiens.UCSC.hg19")
    load(system.file("extdata", "ForTestinguniqueREs.RData",
            package = "CRISPRseek"))
    uniqueREs(results$REcutDetails, results$summary, results$offtarget,
	scanUpstream = 50,
        scanDownstream = 50, BSgenomeName = Hsapiens)
}
\author{
Lihua Julie Zhu
}
\keyword{misc}
