% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GTEX_expression.R
\name{GTEX_expression}
\alias{GTEX_expression}
\title{Gene expression in normal tissues (GTEx)}
\usage{
GTEX_expression(
  genes = NULL,
  units = c("TPM", "log_TPM"),
  include_CTP = FALSE,
  values_only = FALSE
)
}
\arguments{
\item{genes}{\code{character} naming the selected genes. The default
value, \code{NULL}, takes all CT (specific) genes.}

\item{units}{\code{character(1)} with expression values unit.  Can be
\code{"TPM"} (default) or \code{"log_TPM"} (log(TPM + 1)).}

\item{include_CTP}{\code{logical(1)} If \code{TRUE}, CTP genes are included.
(\code{FALSE} by default).}

\item{values_only}{\code{logical(1)}. If \code{TRUE}, the function will return the
expression values in all samples instead of the
heatmap. Default is \code{FALSE}.}
}
\value{
A heatmap of selected genes expression in normal tissues.
If \code{values_only = TRUE}, expression values are returned instead.
}
\description{
Plots an expression heatmap of genes in normal tissues
(GTEx database).
}
\examples{
GTEX_expression(units = "log_TPM")
GTEX_expression(genes = c("MAGEA1", "MAGEA3"), units = "log_TPM")
}
