% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CatsCradleEdgeQualityControl.R
\name{cullEdges}
\alias{cullEdges}
\title{This subsets edges by our chosen critera}
\usage{
cullEdges(annEdges, cutoffSpec)
}
\arguments{
\item{annEdges}{\itemize{
\item a data frame with columns nodeA, nodeB, length
and cellTypePair as produced by edgeLengthsAndCellTypePairs.
}}

\item{cutoffSpec}{\itemize{
\item This can be either a numeric value which will
be applied across all edges as an upper limit or a data frame
with columns cellTypePair and cutoff as produced by any of the
edgeCutoffsBy functions
}}
}
\value{
This returns a subset of the annotated edges
}
\description{
This subsets edges by our chosen critera
}
\examples{
getExample = make.getExample()
centroids = getExample('centroids')
clusters = getExample('clusters')
delaunayNeighbours = getExample('delaunayNeighbours') 
annEdges =
    edgeLengthsAndCellTypePairs(delaunayNeighbours,clusters,centroids)
tolerance = 5
nbins = 15
cutoffDFWater = edgeCutoffsByWatershed(annEdges,
                                      tolerance=tolerance,
                                      nbins=nbins)
culledEdges = cullEdges(annEdges,cutoffDFWater)
}
