% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CatsCradleLigandReceptorAnalysis.R
\name{plotLRDotplot}
\alias{plotLRDotplot}
\title{This is a function to create a dotplot using the ligand receptor results}
\usage{
plotLRDotplot(
  ligandReceptorResults,
  senderClusters = unique(ligandReceptorResults$interactionsOnEdgesMeta$cellTypeA),
  receiverClusters = unique(ligandReceptorResults$interactionsOnEdgesMeta$cellTypeB),
  padjCutoff = 0.05,
  pvalCutoff = F,
  splitBy = "sender"
)
}
\arguments{
\item{ligandReceptorResults}{\itemize{
\item ligandReceptorResults calculated using
performLigandReceptorAnalysis().
}}

\item{senderClusters}{\itemize{
\item sender clusters to plot (defaults to all).
}}

\item{receiverClusters}{\itemize{
\item receiver clusters to plot (defaults to all).
}}

\item{padjCutoff}{\itemize{
\item only plot results with p-adj < padjCutoff (defaults to
0.05).
}}

\item{pvalCutoff}{\itemize{
\item only plot results with p-value < pvalCutoff (defaults to
False in which case padjCutoff is used).
}}

\item{splitBy}{\itemize{
\item split plots by "sender" or "receiver" cell types (defaults
to sender).
}}
}
\value{
matrix of total ligand receptor interactions that underlies the heatmap.
}
\description{
This is a function to create a dotplot using the ligand receptor results
}
\examples{
getExample = make.getExample()
centroids = getExample('centroids')
ligandReceptorResults = getExample('ligandReceptorResults')
p = plotLRDotplot(ligandReceptorResults)
}
