% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diffusion.R
\name{diffusion}
\alias{diffusion}
\title{Network diffusion analysis}
\usage{
diffusion(object, cond, genes, cyPath, name = "top_diffusion", label = TRUE)
}
\arguments{
\item{object}{CeTF object resulted from \code{\link{runAnalysis}} function.}

\item{cond}{Which conditions to be used to perform the diffusion analysis. 
The options are: network1 (1th condition) and network2 (2th condition).}

\item{genes}{A single gene or a vector of characters indicating which genes
will be used to perform diffusion analysis.}

\item{cyPath}{System path of Cytoscape software (see \emph{details} for further 
informations).}

\item{name}{Network output name (default: top_diffusion)}

\item{label}{If label is TRUE, shows the names of nodes (default: TRUE).}
}
\value{
Returns a list with the plot of the network and a table with the 
diffusion network.
}
\description{
Expand node selection using network propagation algorithms 
generating the expanded network for a core of genes and the 
network plot of this subnetwork.
}
\details{
To perform the diffusion analysis is necessary to install the latest Cytoscape 
software version (\url{https://cytoscape.org/}).

The \emph{cyPath} argument varies depending on the operating system used, for
example:
\enumerate{
    \item \strong{For Windows users:} C:/Program Files/Cytoscape_v3.8.0/Cytoscape.exe
    \item \strong{For Linux users:} /home/user/Cytoscape_v3.8.0/Cytoscape
    \item \strong{For macOS users:} /Applications/Cytoscape_v3.8.0/cytoscape.sh
}
}
\examples{
\dontrun{ 
data(CeTFdemo)

result <- diffusion(object = CeTFdemo, 
                    cond = 'network1', 
                    genes = c('ENSG00000185591', 'ENSG00000179094'), 
                    cyPath = 'C:/Program Files/Cytoscape_v3.7.2/Cytoscape.exe', 
                    name = 'top_diffusion',
                    label = TRUE)
}

}
