% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/netGOTFPlot.R
\name{netGOTFPlot}
\alias{netGOTFPlot}
\title{Plot a network for Ontologies, genes and TFs}
\usage{
netGOTFPlot(
  netCond,
  resultsGO,
  netGO,
  anno,
  groupBy = "pathways",
  TFs = NULL,
  genes = NULL,
  keyTFs = NULL,
  size = 0.5,
  type = NULL
)
}
\arguments{
\item{netCond}{Network of a specific condition. Can be found in
result of \code{\link{runAnalysis}} (see \code{\link{NetworkData}} and
\code{\link{NetworkData}}).}

\item{resultsGO}{Dataframe with the results of \code{\link{getGroupGO}}
(first element of list). This result can be filtered by applying filters
for pathways selection.}

\item{netGO}{Dataframe with the results of \code{\link{getGroupGO}}
(second element of list).}

\item{anno}{Annotation of gene or TFs. Can be found in result of
\code{\link{runAnalysis}} function (see \code{\link{NetworkData}}).}

\item{groupBy}{Which variables do you want to group in GO type? The options 
are: 'pathways', 'TFs' and 'genes' (default: 'pathways').}

\item{TFs}{A character with selected TFs.}

\item{genes}{A character with selected genes.}

\item{keyTFs}{TFs identified as importants by \code{\link{runAnalysis}} 
(see \code{\link{NetworkData}}). This argument is used only if the type argument
equals Integrated.}

\item{size}{Size of nodes labels (default: 0.5).}

\item{type}{Type of plot selected (GO or Integrated). If GO will plot the 
associated GO grouped by some variable, and if Integrated will plot a 
integrated network with genes, GO and TFs.}
}
\value{
Returns a list with the plot of the network for GO or integrated 
output under a condition and the table used to plot the network.
}
\description{
Generate the plot of groupGO network result of
\code{\link{getGroupGO}} function, and the integrated network of genes, GOs 
and TFs.
}
\examples{
\dontrun{ 
# load the annotation package
library(org.Hs.eg.db)

# load the CeTF class object resulted from runAnalysis function
data(CeTFdemo)

# getting the genes in network of condition 1
genes <- unique(c(as.character(NetworkData(CeTFdemo, 'network1')[, 'gene1']),
                 as.character(NetworkData(CeTFdemo, 'network1')[, 'gene2'])))

# performing getGroupGO analysis
cond1 <- getGroupGO(genes = genes,
                    ont = 'BP',
                    keyType = 'ENSEMBL',
                    annoPkg = org.Hs.eg.db, 
                    level = 3)

# selecting only first 12 pathways
t1 <- head(cond1$results, 12)

# subsetting the network to have only the first 12 pathways
t2 <- subset(cond1$netGO, cond1$netGO$gene1 \%in\% as.character(t1[, 'ID']))

# generate the GO plot grouping by pathways
pt <- netGOTFPlot(netCond = NetworkData(CeTFdemo, 'network1'),
              resultsGO = t1,
              netGO = t2,
              anno = NetworkData(CeTFdemo, 'annotation'),
              groupBy = 'pathways',
              keyTFs = NetworkData(CeTFdemo, 'keytfs'), 
              type = 'GO')
pt$plot
head(pt$tab$`GO:0006807`)

# generate the Integrated plot
pt <- netGOTFPlot(netCond = NetworkData(CeTFdemo, 'network1'),
              resultsGO = t1,
              netGO = t2,
              anno = NetworkData(CeTFdemo, 'annotation'),
              groupBy = 'pathways',
              keyTFs = NetworkData(CeTFdemo, 'keytfs'), 
              type = 'Integrated')
pt$plot
head(pt$tab)
}

}
