% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/method-cure_barcode.R
\name{bc_cure_umi}
\alias{bc_cure_umi}
\alias{bc_cure_umi,BarcodeObj-method}
\title{Filters UMI-barcode tag by counts}
\usage{
bc_cure_umi(barcodeObj, depth = 2, doFish = FALSE, isUniqueUMI = FALSE)

\S4method{bc_cure_umi}{BarcodeObj}(barcodeObj, depth = 1, doFish = FALSE, isUniqueUMI = FALSE)
}
\arguments{
\item{barcodeObj}{A BarcodeObj object.}

\item{depth}{A numeric or a vector of numeric, specifying the UMI-barcode
tag count threshold. Only the barcodes with UMI-barcode tag count equal to or larger than
the threshold are kept.}

\item{doFish}{A logical value, if true, for barcodes with UMI read depth
above the threshold, “fish” for identical barcodes with UMI read depth below
the threshold. The consequence of \code{doFish} will not increase the number
of identified barcodes, but the UMI counts will increase due to including the
low depth UMI barcodes.}

\item{isUniqueUMI}{A logical value. In the case that a UMI
relates to several barcodes, if you believe that the UMI is absolutely unique,
then only the UMI-barcodes tags with the highest count are kept for each UMI.}
}
\value{
A \code{BarcodeObj} object with \code{cleanBc} slot updated (or
created).
}
\description{
When the UMI is applied, \code{bc_cure_umi} can filter the UMI-barcode tags
by counts.
}
\details{
When invoking this function, it processes the data with following
steps:
\enumerate{
  \item (if isUniqueUMI is TRUE) Find the dominant UMI-barcode tag with the highest
  reads count in each UMI.
  \item UMI-barcode depth filtering.
  \item (if doFish is TRUE) Fishing the UMI-barcode tags with low reads
  count.
}
}
\examples{
data(bc_obj)

d1 <- data.frame(
   seq = c(
       "ACTTCGATCGATCGAAAAGATCGATCGATC",
       "AATTCGATCGATCGAAGAGATCGATCGATC",
       "CCTTCGATCGATCGAAGAAGATCGATCGATC",
       "TTTTCGATCGATCGAAAAGATCGATCGATC",
       "AAATCGATCGATCGAAGAGATCGATCGATC",
       "CCCTCGATCGATCGAAGAAGATCGATCGATC",
       "GGGTCGATCGATCGAAAAGATCGATCGATC",
       "GGATCGATCGATCGAAGAGATCGATCGATC",
       "ACTTCGATCGATCGAACAAGATCGATCGATC",
       "GGTTCGATCGATCGACGAGATCGATCGATC",
       "GCGTCCATCGATCGAAGAAGATCGATCGATC"
       ),
   freq = c(
       30, 60, 9, 10, 14, 5, 10, 30, 6, 4 , 6
       )
   )

pattern <- "([ACTG]{3})TCGATCGATCGA([ACTG]+)ATCGATCGATC"
bc_obj <- bc_extract(list(test = d1), pattern, sample_name=c("test"), 
    pattern_type=c(UMI=1, barcode=2))

# Use UMI information to remove the barcode <= 5 UMI-barcode tags
bc_umi_cured <- bc_cure_umi(bc_obj, depth =0, doFish=TRUE, isUniqueUMI=TRUE)
bc_cure_depth(bc_umi_cured, depth = 5)

}
