% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fn_arg_seq.R
\name{fn_arg_seq}
\alias{fn_arg_seq}
\title{Create a list of functions with arguments varying over a sequence}
\usage{
fn_arg_seq(func, ..., .strict = FALSE)
}
\arguments{
\item{func}{function to generate list from}

\item{...}{vectors of values to use as arguments}

\item{.strict}{TRUE if argument names are checked, giving an error if
specified argument does not appear in function signature. Note that
functions with multiple methods generally have only f(x, ...) as their
signature, so the check would fail even if the arguments are passed on.}
}
\value{
list of functions with the specified arguments pre-applied. Names of
    the list indicate the values that have been pre-applied.
}
\description{
Generate a list of functions where specific arguments have been pre-applied
from a sequences of arguments, i.e. a function f(x, n) may have the 'n'
argument pre-applied with specific values to obtain functions f1(x, n = 1)
and f2(x, n = 2) stored in a list.
}
\details{
If multiple argument vectors are provided
then the combinations of arguments in the sequences will be generated.
}
\examples{
f <- function(x) {
    cat("x:", x)
}

f_list <- fn_arg_seq(f, x = c(1, 2))
f_list
f_list[[1]]() # x: 1
f_list[[2]]() # x: 2

g <- function(x, y) {
    cat("x:", x, "y:", y)
}

g_list <- fn_arg_seq(g, x = c(1, 2), y = c(3, 4))
g_list
g_list[[1]]() # x: 1 y: 3
g_list[[2]]() # x: 1 y: 4
g_list[[3]]() # x: 2 y: 3
g_list[[4]]() # x: 2 y: 4
}
