% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/benchmark_timing_tbl_methods.R
\name{unpack_timing}
\alias{unpack_timing}
\alias{unpack_timing.benchmark_timing_tbl}
\title{Unpack timing information}
\usage{
unpack_timing(x)

\method{unpack_timing}{benchmark_timing_tbl}(x)
}
\arguments{
\item{x}{the benchmark_timing_tbl object}
}
\value{
a tibble containing pipeline steps and timing information
}
\description{
Takes the result of a time_methods() call and remove the `timed_result`
column, replacing it with three columns of durations representing the
`system`, `user` and `elapsed` times from a system.time() call.
}
\examples{
\dontrun{
datasets <- list(
    data1 = c(1, 2, 3)
)

transforms <- list(
    log = function(x) { Sys.sleep(0.1); log(x) },
    sqrt = function(x) { Sys.sleep(0.1); sqrt(x) }
)

datasets \%>\%
    time_methods(transforms) \%>\%
    unpack_timing()
}

}
\seealso{
\code{\link{strip_timing}}
}
\keyword{internal}
