% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import-methods.R
\docType{methods}
\name{read.ygraphml}
\alias{read.ygraphml}
\title{Reads trajectory graph layout}
\usage{
read.ygraphml(file)
}
\arguments{
\item{file}{A character string naming a file}
}
\value{
An \code{data.frame} with coordinates of data points and
visualization metadata
}
\description{
Reads ygraphml file containing the trajectory graph's layout
}
\details{
To visualize the trajectory graph, a proper graph layout has
to be computed. Ideally, edges should not cross and nodes should not
overlap. CellTrails enables the export and import of the trajectory
graph structure using the graphml file format. This file format can be
interpreted by most third-party graph analysis applications, allowing
the user to subject the trajectory graph to a wide range of layout
algorithms. Please note that the graphml file needs to contain layout
information ("<y:Geometry x=... y=... >" entries) as provided by the
'ygraphml' file definition used by the Graph Visualization Software
'yEd' (freely available from yWorks GmbH,
http://www.yworks.com/products/yed).
}
\examples{
# Example data
data(exSCE)

\dontrun{
fn <- system.file("exdata", "exDat.graphml", package="CellTrails")
tl <- read.ygraphml(fn)
}
}
\seealso{
\code{write.ygraphml}
}
\author{
Daniel C. Ellwanger
}
