% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessor-methods.R
\docType{methods}
\name{trajLayout<-}
\alias{trajLayout<-}
\alias{trajLayout<-,SingleCellExperiment-method}
\title{SET trajectory layout}
\usage{
trajLayout(object, adjust) <- value
}
\arguments{
\item{object}{An object of class \code{SingleCellExperiment}}

\item{adjust}{Indicates if layout has to be adjusted such that edge lengths
correlate to pseudotime (default: TRUE)}

\item{value}{A data.frame with x- and y-coordinates for
each sample (rows = samples, columns = coordinates)}
}
\value{
An updated object of class \code{SingleCellExperiment}
}
\description{
Sets layout used for trajectory visualization to a
\code{SingleCellExperiment} object.
}
\details{
CellTrails implements a module which can incorporate pseudotime information
into the the graph layout (activated via parameter \code{adjust}). Here,
edge lengths between two nodes (samples)
will then correspond to the inferred pseudotime that separates two samples
along the trajectory.
\cr \cr
\emph{Diagnostic messages}
\cr \cr
An error is thrown if the number of rows of the layout does not correspond
to the number of trajectory samples or if the number of columns is
less than 2, or if the row names do not correspond to \code{sampleNames}.
}
\examples{
# Example data
data(exSCE)
tl <- trajLayout(exSCE)

trajLayout(exSCE) <- tl
}
\seealso{
\code{write.ygraphml} \code{trajSampleNames}
}
\author{
Daniel C. Ellwanger
}
