% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Cepo.R
\name{setCepoBPPARAM}
\alias{setCepoBPPARAM}
\title{Setting parallel params based on operating platform}
\usage{
setCepoBPPARAM(workers = 1L, ...)
}
\arguments{
\item{workers}{Number of cores to use. Default to 1, which invokes
\code{BiocParallel::SerialParam}.
For workers greater than 1, see the \code{workers} argument in
\code{BiocParallel::MulticoreParam} and \code{BiocParallel::SnowParam}.}

\item{...}{Additional arguments passed to \code{BiocParallel::MulticoreParam}
and \code{BiocParallel::SnowParam}.}
}
\value{
Parameters for parallel computing depending on OS
}
\description{
Setting parallel params based on operating platform
}
\examples{
# system.time(BiocParallel::bplapply(1:3, FUN = function(i){Sys.sleep(i)}, 
# BPPARAM = setCepoBPPARAM(workers = 1)))
# system.time(BiocParallel::bplapply(1:3, FUN = function(i){Sys.sleep(i)}, 
# BPPARAM = setCepoBPPARAM(workers = 3)))
}
