% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metagene.R
\name{metagenePlot}
\alias{metagenePlot}
\title{peak distance to features}
\usage{
metagenePlot(
  peaks,
  AnnotationData,
  PeakLocForDistance = c("middle", "start", "end"),
  FeatureLocForDistance = c("TSS", "middle", "geneEnd"),
  upstream = 1e+05,
  downstream = 1e+05
)
}
\arguments{
\item{peaks}{peak list, \link[GenomicRanges:GRanges-class]{GRanges} object or
a \link[GenomicRanges:GRangesList-class]{GRangesList}.}

\item{AnnotationData}{A \link[GenomicRanges:GRanges-class]{GRanges} object 
or a \link[GenomicFeatures:TxDb-class]{TxDb} object.}

\item{PeakLocForDistance}{Specify the location of peak for calculating
distance,i.e., middle means using middle of the peak to calculate distance
to feature, start means using start of the peak to calculate the distance to
feature. To be compatible with previous version, by default using start}

\item{FeatureLocForDistance}{Specify the location of feature for calculating
distance,i.e., middle means using middle of the feature to calculate
distance of peak to feature, TSS means using start of feature when
feature is on plus strand and using end of feature when feature is on minus
strand, geneEnd means using end of feature when feature is on plus strand
and using start of feature when feature is on minus strand.}

\item{upstream, downstream}{numeric(1). Upstream or downstream region of
features to plot.}
}
\description{
Bar plot for distance to features
}
\details{
the bar heatmap is indicates the peaks around features.
}
\examples{
path <- system.file("extdata", package="ChIPpeakAnno")
files <- dir(path, "broadPeak")
peaks <- sapply(file.path(path, files), toGRanges, format="broadPeak")
peaks <- GRangesList(peaks)
names(peaks) <- sub(".broadPeak", "", basename(names(peaks)))
library(TxDb.Hsapiens.UCSC.hg19.knownGene)
metagenePlot(peaks, TxDb.Hsapiens.UCSC.hg19.knownGene)
}
