% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlation_filtering_clustering.R
\name{consensus_clustering_scExp}
\alias{consensus_clustering_scExp}
\title{Wrapper to apply ConsensusClusterPlus to scExp object}
\usage{
consensus_clustering_scExp(
  scExp,
  prefix = NULL,
  maxK = 10,
  reps = 100,
  pItem = 0.8,
  pFeature = 1,
  distance = "pearson",
  clusterAlg = "hc",
  innerLinkage = "ward.D",
  finalLinkage = "ward.D",
  plot_consclust = "pdf",
  plot_icl = "png"
)
}
\arguments{
\item{scExp}{A SingleCellExperiment object containing 'PCA' in reducedDims.}

\item{prefix}{character value for output directory. Directory is created only
if plot_consclust is not NULL. This title can be an abosulte or relative
path.}

\item{maxK}{integer value. maximum cluster number to evaluate. (10)}

\item{reps}{integer value. number of subsamples. (100)}

\item{pItem}{numerical value. proportion of items to sample. (0.8)}

\item{pFeature}{numerical value. proportion of features to sample. (1)}

\item{distance}{character value. 'pearson': (1 - Pearson correlation),
'spearman' (1 - Spearman correlation), 'euclidean', 'binary', 'maximum',
'canberra', 'minkowski' or custom distance function. ('pearson')}

\item{clusterAlg}{character value. cluster algorithm. 'hc' heirarchical
(hclust), 'pam' for paritioning around medoids, 'km' for k-means upon data
matrix, 'kmdist' ('hc') for k-means upon distance matrices (former km
option), or a function that returns a clustering. ('hc')}

\item{innerLinkage}{hierarchical linkage method for subsampling. ('ward.D')}

\item{finalLinkage}{hierarchical linkage method for consensus matrix.
('ward.D')}

\item{plot_consclust}{character value. NULL - print to screen, 'pdf', 'png',
'pngBMP' for bitmap png, helpful for large datasets. ('pdf')}

\item{plot_icl}{same as above for item consensus plot. ('png')}
}
\value{
Returns a SingleCellExperiment object containing consclust list,
calculated cluster consensus and item consensus scores in metadata.
}
\description{
Runs consensus hierarchical clustering on PCA feature space of scExp object.
Plot consensus scores for each number of clusters. See
\link[ConsensusClusterPlus]{ConsensusClusterPlus} - Wilkerson, M.D., Hayes,
D.N. (2010). ConsensusClusterPlus: a class discovery tool with confidence
assessments and item tracking. Bioinformatics, 2010 Jun 15;26(12):1572-3.
}
\details{
This functions takes as input a SingleCellExperiment object that must have
'PCA' in reducedDims and outputs a SingleCellExperiment object containing
consclust list calculated cluster consensus and item consensus scores in
metadata.
}
\examples{
data("scExp")
scExp_cf = correlation_and_hierarchical_clust_scExp(scExp)
scExp_cf = consensus_clustering_scExp(scExp)

}
\references{
ConsensusClusterPlus package by Wilkerson, M.D., Hayes, D.N.
(2010). ConsensusClusterPlus: a class discovery tool with confidence
assessments and item tracking. Bioinformatics, 2010 Jun 15;26(12):1572-3.
}
