% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_functions.R
\name{plot_correlation_PCA_scExp}
\alias{plot_correlation_PCA_scExp}
\title{Plotting correlation of PCs with a variable of interest}
\usage{
plot_correlation_PCA_scExp(
  scExp,
  correlation_var = "total_counts",
  color_by = NULL,
  topPC = 10
)
}
\arguments{
\item{scExp}{A SingleCellExperiment Object}

\item{correlation_var}{A string specifying with which numeric variable from
colData of scExp to calculate and plot the correlation of each PC with.
('total_counts')}

\item{color_by}{A string specifying with which categorical variable to
color the plot. ('NULL')}

\item{topPC}{An integer specifying the number of PCs to plot correlation
with 10}
}
\value{
A ggplot histogram representing the distribution of count per cell
}
\description{
Plotting correlation of PCs with a variable of interest
}
\examples{
data("scExp")
plot_correlation_PCA_scExp(scExp, topPC = 25)
plot_correlation_PCA_scExp(scExp, color_by = "cell_cluster")
plot_correlation_PCA_scExp(scExp, color_by = "sample_id")
}
