% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coverage.R
\name{rawfile_ToBigWig}
\alias{rawfile_ToBigWig}
\title{rawfile_ToBigWig : reads in BAM file and write out BigWig coverage file,
normalized and smoothed}
\usage{
rawfile_ToBigWig(
  input,
  BigWig_filename,
  format = "BAM",
  bin_width = 150,
  norm_factor,
  n_smoothBin = 5,
  ref = "hg38",
  read_size = 101,
  original_bins = NULL,
  quantile_for_peak_calling = 0.85
)
}
\arguments{
\item{input}{Either a named list of character vector of path towards
single-cell BED files or a sparse raw matrix of small bins (<<500bp). If
a named list specifying scBEDn the names MUST correspond to the 'sample_id'
column in your SingleCellExperiment object. The single-cell BED files names MUST
match the  barcode names in your SingleCellExperiment (column 'barcode'). The
scBED files can be gzipped or not.}

\item{BigWig_filename}{Path to write the output BigWig file}

\item{format}{File format, either "BAM" or "BED"}

\item{bin_width}{Bin size for coverage}

\item{norm_factor}{Then number of cells or total number of reads in the given
sample, for normalization.}

\item{n_smoothBin}{Number of bins for smoothing values}

\item{ref}{Reference genome.}

\item{read_size}{Length of the reads.}

\item{original_bins}{Original bins GenomicRanges in case the format is raw
matrix.}

\item{quantile_for_peak_calling}{The quantile to define the threshold above
which signal is considered as a peak.}
}
\value{
Writes in the output directory a bigwig file displaying the
cumulative coverage of cells and a basic set of peaks called by taking all
peaks above a given threshold

Writes a BigWig file as output
}
\description{
rawfile_ToBigWig : reads in BAM file and write out BigWig coverage file,
normalized and smoothed
}
