% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QCfunctions.R
\name{readFrom10X}
\alias{readFrom10X}
\title{readFrom10X}
\usage{
readFrom10X(
  dir,
  type = c("auto", "sparse", "HDF5"),
  feature_named_by = c("gene_id", "gene_symbol"),
  filter_features = TRUE
)
}
\arguments{
\item{dir}{A character indicates the directory of the 10X files}

\item{type}{A character indicates the format of the data, sparse or HDF5}

\item{feature_named_by}{A character indicates whehter the genes
will be named by gene_id or gene_symbol}

\item{filter_features}{A logical input indicates whether the features
with all zeros will be removed}
}
\value{
a SingleCellExperiment object
}
\description{
A function to read the data from 10X
}
\examples{

\dontrun{
tmpdir <- tempdir()
tenXdata <- "http://cf.10xgenomics.com/samples/cell-exp/3.1.0/connect_5k_pbmc_NGSC3_ch1/"
file <- "connect_5k_pbmc_NGSC3_ch1_filtered_feature_bc_matrix.tar.gz"
download.file(paste0(tenXdata, file),file.path(tmpdir, file))
untar(file.path(tmpdir,file),
      exdir = tmpdir)
sce_citeseq_10X <- readFrom10X(file.path(tmpdir,
"filtered_feature_bc_matrix/"))
sce_citeseq_10X
}

}
