% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_clusters_graph.r
\name{plotClustersGraph}
\alias{plotClustersGraph}
\title{Creates a graph plot using the similarity values calculated with ClusterFoldSimilarity().}
\usage{
plotClustersGraph(similarityTable = NULL)
}
\arguments{
\item{similarityTable}{Dataframe. A table obtained from ClusterFoldSimilarity that contains the similarity values as a column "similarityValue" that represents 
the similarity of a source cluster to a target cluster.}
}
\value{
This function plots a graph in which the nodes are clusters from a specific dataset, the edges represent the similarity and the direction
of that similarity between clusters.
}
\description{
`plotClustersGraph()` Creates a graph plot using the similarity values calculated with ClusterFoldSimilarity().
}
\details{
This function will calculate a similarity coeficient using the fold changes of shared genes among clusters of different samples/batches. The similarity coeficient
is calculated using the dotproduct of every pairwise combination of Fold Changes between a source cluster i of sample n and all the target clusters in sample j.
}
\examples{
if (requireNamespace("Seurat") & requireNamespace("SeuratObject")){
library(ClusterFoldSimilarity)
library(Seurat)
library(SeuratObject)
# data dimensions
nfeatures <- 2000; ncells <- 400
# single-cell 1
counts <- matrix(rpois(n=nfeatures * ncells, lambda=10), nfeatures)
rownames(counts) <- paste0("gene",seq(nfeatures))
colnames(counts) <- paste0("cell",seq(ncells))
colData <- data.frame(cluster=sample(c("Cluster1","Cluster2","Cluster3"),size = ncells,replace = TRUE),
                     row.names=paste0("cell",seq(ncells)))
seu1 <- SeuratObject::CreateSeuratObject(counts = counts, meta.data = colData)
Idents(object = seu1) <- "cluster"
# single-cell 2
counts <- matrix(rpois(n=nfeatures * ncells, lambda=10), nfeatures)
rownames(counts) <- paste0("gene",seq(nfeatures))
colnames(counts) <- paste0("cell",seq(ncells))
colData <- data.frame(cluster=sample(c("Cluster1","Cluster2","Cluster3","Cluster4"),size = ncells,replace = TRUE),
                      row.names=paste0("cell",seq(ncells)))
seu2 <- SeuratObject::CreateSeuratObject(counts = counts, meta.data = colData)
Idents(object = seu2) <- "cluster"
# Create a list with the unprocessed single-cell datasets
singlecellObjectList <- list(seu1, seu2)

similarityTable <- clusterFoldSimilarity(scList = singlecellObjectList, sampleNames = c("sc1","sc2"))
head(similarityTable)
plotClustersGraph(similarityTable=similarityTable)
}

}
\author{
Oscar Gonzalez-Velasco
}
