% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/similarity_heatmap.r
\name{similarityHeatmap}
\alias{similarityHeatmap}
\title{Plot a heatmap of the similarity values obtained using cluster fold similarity}
\usage{
similarityHeatmap(
  similarityTable = NULL,
  mainDataset = NULL,
  otherDatasets = NULL,
  highlightTop = TRUE
)
}
\arguments{
\item{similarityTable}{A DataFrame containing the similarities between all possible pairs of single cell samples obtained with \link[ClusterFoldSimilarity]{clusterFoldSimilarity} using the option n_top=Inf.}

\item{mainDataset}{Numeric. Specify the main dataset (y axis). It corresponds with the datasetL column from the similarityTable}

\item{otherDatasets}{Numeric. Specify some specific dataset to be ploted along the mainDataset (x axis, default: all other datasets found on datasetR column from similarity_table).}

\item{highlightTop}{Boolean. If the top 2 similarity values should be highlighted on the heatmap (default: TRUE)}
}
\value{
The function returns a heatmap ggplot object.
}
\description{
`similarityHeatmap()` returns a ggplot heatmap representing the similarity values between pairs of clusters as obtained from \link[ClusterFoldSimilarity]{clusterFoldSimilarity}.
}
\details{
This function plots a heatmap using ggplot. It is intended to be used with the output table from \link[ClusterFoldSimilarity]{clusterFoldSimilarity}, which includes the columns: datasetL (the dataset used for comparison)
datasetR (the dataset against datasetL has been contrasted), clusterL (clusters from datasetL), clusterR (clusters from datasetR) and the similarityValue.
}
\examples{
if (requireNamespace("Seurat") & requireNamespace("SeuratObject")){
library(ClusterFoldSimilarity)
library(Seurat)
library(SeuratObject)
# data dimensions
nfeatures <- 2000; ncells <- 400
# single-cell 1
counts <- matrix(rpois(n=nfeatures * ncells, lambda=10), nfeatures)
rownames(counts) <- paste0("gene",seq(nfeatures))
colnames(counts) <- paste0("cell",seq(ncells))
colData <- data.frame(cluster=sample(c("Cluster1","Cluster2","Cluster3"),size = ncells,replace = TRUE),
                     row.names=paste0("cell",seq(ncells)))
seu1 <- SeuratObject::CreateSeuratObject(counts = counts, meta.data = colData)
Idents(object = seu1) <- "cluster"
# single-cell 2
counts <- matrix(rpois(n=nfeatures * ncells, lambda=10), nfeatures)
rownames(counts) <- paste0("gene",seq(nfeatures))
colnames(counts) <- paste0("cell",seq(ncells))
colData <- data.frame(cluster=sample(c("Cluster1","Cluster2","Cluster3","Cluster4"),size = ncells,replace = TRUE),
                      row.names=paste0("cell",seq(ncells)))
seu2 <- SeuratObject::CreateSeuratObject(counts = counts, meta.data = colData)
Idents(object = seu2) <- "cluster"
# Create a list with the unprocessed single-cell datasets
singlecellObjectList <- list(seu1, seu2)
# Using topN = Inf by default plots a heatmap using the similarity values: 
similarityTableAll <- clusterFoldSimilarity(scList=singlecellObjectList, topN=Inf)
# Using the dataset 2 as a reference on the Y-axis of the heatmap:
similarityHeatmap(similarityTable=similarityTableAll, mainDataset=2, highlightTop=FALSE)
}

}
\author{
Oscar Gonzalez-Velasco
}
