% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CoGAPS.R
\name{scCoGAPS}
\alias{scCoGAPS}
\title{Single Cell CoGAPS}
\usage{
scCoGAPS(
  data,
  params = new("CogapsParams"),
  nThreads = 1,
  messages = TRUE,
  outputFrequency = 500,
  uncertainty = NULL,
  checkpointOutFile = "gaps_checkpoint.out",
  checkpointInterval = 1000,
  checkpointInFile = NULL,
  transposeData = FALSE,
  BPPARAM = NULL,
  workerID = 1,
  asynchronousUpdates = FALSE,
  ...
)
}
\arguments{
\item{data}{File name or R object (see details for supported types)}

\item{params}{CogapsParams object}

\item{nThreads}{maximum number of threads to run on}

\item{messages}{T/F for displaying output}

\item{outputFrequency}{number of iterations between each output (set to 0 to
disable status updates, other output is controlled by @code messages)}

\item{uncertainty}{uncertainty matrix - either a matrix or a supported
file type}

\item{checkpointOutFile}{name of the checkpoint file to create}

\item{checkpointInterval}{number of iterations between each checkpoint (set
to 0 to disable checkpoints)}

\item{checkpointInFile}{if this is provided, CoGAPS runs from the checkpoint
contained in this file}

\item{transposeData}{T/F for transposing data while reading it in - useful
for data that is stored as samples x genes since CoGAPS requires data to be
genes x samples}

\item{BPPARAM}{BiocParallel backend}

\item{workerID}{if calling CoGAPS in parallel the worker ID can be specified,
only worker 1 prints output and each worker outputs when it finishes, this
is not neccesary when using the default parallel methods (i.e. distributed
CoGAPS) but only when the user is manually calling CoGAPS in parallel}

\item{asynchronousUpdates}{enable asynchronous updating which allows for multi-threaded runs}

\item{...}{allows for overwriting parameters in params}
}
\value{
CogapsResult object
}
\description{
wrapper around single-cell distributed algorithm for CoGAPS
}
\examples{
\dontrun{
data(GIST)
params <- new("CogapsParams", nPatterns=3)
params <- setDistributedParams(params, nSets=2)
params <- setParam(params, "nIterations", 100)
result <- scCoGAPS(t(GIST.matrix), params, BPPARAM=BiocParallel::SerialParam())
}
}
