% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loadCopyNumberCallsCNVkit.R
\name{loadCopyNumberCallsCNVkit}
\alias{loadCopyNumberCallsCNVkit}
\title{loadCopyNumberCallsCNVkit}
\usage{
loadCopyNumberCallsCNVkit(cnvkit.file, chr.col = "chromosome", start.col = "start", end.col = "end", segment.value.col = "log2", file.type = "auto", cn.col = NULL, zero.based = TRUE, genome = NULL, verbose = TRUE)
}
\arguments{
\item{cnvkit.file}{The name of the file with the data}

\item{chr.col}{(number or character) The name or number of the column with chromosome information. If NULL, it is automatically identified. (defaults to "chromosome")}

\item{start.col}{(number or character) The name or number of the column with start position information. If NULL, it is automatically identified. (defaults to "start")}

\item{end.col}{(number or character) The name or number of the column with end position information. If NULL, it is automatically identified. (defaults to "end")}

\item{segment.value.col}{(number or character) The name or number of the column with segment value. If NULL, it is automatically identified. (defaults to "log2")}

\item{file.type}{(character) wheter to load ".cns", ".cnr" or "auto" if the file type is automatically recognised. (defaults to "auto)}

\item{cn.col}{(number or character) The name or number of the column with CN information. If NULL, it is automatically identified. (defaults to NULL)}

\item{zero.based}{(logical) Whether the data is zero-based and half open (i.e. ranges are defined by (start:end] so chr1:10-20 represents nine bases long features spanning from base 11 to 20). (defaults to FALSE)}

\item{genome}{(character) The name of the genome (defaults to NULL)}

\item{verbose}{(logical) Whether to show information messages. (defaults to TRUE)}
}
\value{
A GRanges with a range per copy number segment.
}
\description{
Loads copy number calls from CNVkit.cns file format
}
\details{
This function will load segments data from CNVkit.cns file format and from CNVkit.cnr. 
Internally it uses the \code{toGRanges} function from regioneR
package and can work with any format accepted by it, including R objects
and local or remote files. 
If no column names are specified, it will use simple heuristics to try to
identify the relevant data columns.
}
\examples{
## loadCopyNumberCallsCNVkit from .cns file format:
## An example of .cns file format is found at https://github.com/etal/cnvkit/blob/master/test/formats/cl_seq.cns.

# Loading a CNVkit.cns file 
cnvkit.file <- system.file("extdata", "CNVkit_output.cns", package = "CopyNumberPlots", mustWork = TRUE)
cnv.call <- loadCopyNumberCallsCNVkit(cnvkit.file)

# Loading a CNVkit.cnr file
cnvkit.file <- system.file("extdata", "CNVkit_output.cnr", package = "CopyNumberPlots", mustWork = TRUE)
cnv.call <- loadCopyNumberCallsCNVkit(cnvkit.file)

}
