% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loadCopyNumberCallsDECoN.R
\name{loadCopyNumberCallsDECoN}
\alias{loadCopyNumberCallsDECoN}
\title{loadCopyNumberCallsDECoN}
\usage{
loadCopyNumberCallsDECoN(decon.file, chr.col = NULL, start.col = "Start", end.col = "End", cn.col = NULL, segment.value.col = NULL, genome = NULL, verbose = TRUE)
}
\arguments{
\item{decon.file}{The name of the file with the data}

\item{chr.col}{(number or character) The name or number of the column with chromosome information. If NULL, it is automatically identified. (defaults to NULL)}

\item{start.col}{(number or character) The name or number of the column with start position information. If NULL, it is automatically identified. (defaults to "Start")}

\item{end.col}{(number or character) The name or number of the column with end position information. If NULL, it is automatically identified. (defaults to "End")}

\item{cn.col}{(number or character) The name or number of the column with CN information. If NULL, it is automatically identified. (defaults to NA)}

\item{segment.value.col}{(number or character) The name or number of the column with segment value. If NULL, it is automatically identified. (defaults to NULL)}

\item{genome}{(character) The name of the genome. (defaults to NULL)}

\item{verbose}{(logical) Whether to show information messages. (defaults to TRUE)}
}
\value{
A GRanges with a range per copy number segment or a list of GRanges with a GRanges per sample.
}
\description{
Loads copy number calls from DECoN  output file
}
\details{
This function will load segments data from DECoN output file. 
Internally it uses the \code{toGRanges} function from regioneR
package and can work with any format accepted by it, including R objects
and local or remote files. 
If no column names are specified, it will use simple heuristics to try to
identify the relevant data columns.
}
\examples{
decon.file <- system.file("extdata", "DECoN_output.txt", package = "CopyNumberPlots", mustWork = TRUE)
cn.calls <- loadCopyNumberCallsDECoN(decon.file = decon.file)

}
