% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-guessMapping.R
\name{guessMapping,LongTableDataMapper-method}
\alias{guessMapping,LongTableDataMapper-method}
\title{Guess which columns in raw experiment data map to which dimensions.}
\usage{
\S4method{guessMapping}{LongTableDataMapper}(object, groups, subset, data = FALSE)
}
\arguments{
\item{object}{A \code{LongTableDataMapper} object.}

\item{groups}{A \code{list} containing one or more vector of column names
to group-by. The function uses these to determine 1:1 mappings between
the combination of columns in each vector and unique values in the raw
data columns.}

\item{subset}{A \code{logical} vector indicating whether to to subset out mapped
columns after each grouping. Must be a single \code{TRUE} or \code{FALSE} or have
the same length as groups, indicating whether to subset out mapped columns
after each grouping. This will prevent mapping a column to two different
groups.}

\item{data}{A \code{logical} vector indicating whether you would like the data
for mapped columns to be returned instead of their column names. Defaults
to \code{FALSE} for easy use assigning mapped columns to a \code{DataMapper} object.}
}
\value{
A \code{list}, where each item is named for the associated \code{groups} item
the guess is for. The character vector in each item are columns which are
uniquely identified by the identifiers from that group.
}
\description{
Checks for columns which are uniquely identified by a group of identifiers.
This should be used to help identify the columns required to uniquely
identify the rows, columns, assays and metadata of a \code{DataMapper} class
object.
}
\details{
Any unmapped columns will be added to the end of the returned \code{list} in an
item called unmapped.

The function automatically guesses metadata by checking if any columns have
only a single value. This is returned as an additional item in the list.
}
\examples{
guessMapping(exampleDataMapper, groups=list(rows='treatmentid', cols='sampleid'),
subset=FALSE)

}
