% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CrisprRun.R
\docType{class}
\name{CrisprRun-class}
\alias{CrisprRun-class}
\alias{CrisprRun}
\title{CrisprRun class}
\arguments{
\item{bam}{a GAlignments object containing (narrowed) alignments to the target region.
Filtering of the bam should generally be done before initialising a CrisprRun object}

\item{target}{The target location, a GRanges object}

\item{genome.ranges}{A GRangesList of genomic coordinates for the cigar operations.
If bam is a standard GAlignments object, this is equivalent to
cigarRangesAlongReferenceSpace + start(bam)}

\item{rc}{(reverse complement)  Should the alignments be reverse complemented,
i.e. displayed with respect to the negative strand?  (Default: FALSE)}

\item{name}{A name for this set of reads, used in plots if present (Default: NULL)}

\item{chimeras}{Off-target chimeric alignments not in bam.  (Default: empty)}

\item{verbose}{Print information about initialisation progress (Default: FALSE)}
}
\description{
A ReferenceClass container for a single sample of alignments narrowed
to a target region.  Typically CrisprRun objects will not be accessed directly,
but if necessary via a CrisprSet class which contains a list of CrisprRun objects.  
Note that the CrispRVariants plotting functions don't work on CrisprRun objects.
}
\section{Fields}{

\describe{
\item{\code{alns}}{A GAlignments object containing the narrowed reads.  Note that if the alignments
are represented with respect to the reverse strand, the "start" remains with repect to the
forward strand, whilst the cigar and the sequence are reverse complemented.}

\item{\code{name}}{The name of the sample}

\item{\code{cigar_labels}}{A vector of labels for the reads, based on the cigar strings,
optionally renumbered with respect to a new zero point (e.g. the cut site) and
shortened to only insertion and deletion locations.
Set at initialisation of a CrisprSet object, but not at
initialisation of a CrisprRun object.}

\item{\code{chimeras}}{Chimeric, off-target alignments corresponding to alignments in alns}
}}

\section{Methods}{

\describe{
\item{\code{getCigarLabels(
  target,
  target.loc,
  genome_to_target,
  ref,
  separate.snv,
  rc,
  match.label,
  mismatch.label,
  keep.ops = c("I", "D", "N"),
  upstream = min(target.loc, 8),
  downstream = min(6, width(ref) - target.loc + 1),
  regions = NULL,
  snv.regions = NULL
)}}{Description:
  Sets the "cig_labels" field, returns the cigar labels.

Input parameters:
  target:           (GRanges) the counting region.
  target.loc:       The location of the cut site with respect to the target
  genome_to_target: A vector with names being genomic locations and values
                    being locations with respect to the cut site
  separate.snv:     Should single nucleotide variants be called?  
                    (Default: TRUE)
  match.label:      Label for non-variant reads (Default: no variant)
  mismatch.label:   Label for single nucleotide variants (Default: SNV)
  rc:               Should the variants be displayed with respect to the 
                    negative strand? (Default: FALSE)
  keep.ops:         CIGAR operations to remain in the variant label
                    (usually indels)
  upstream:         distance upstream of the cut site to call SNVs
  downstream:       distance downstream of the cut site to call SNVs
  regions:          IRanges(k) Regions for counting insertions and
                    deletions.  Insertions on the right border are not
                    counted.
  snv.regions       Regions for calling SNVS}

\item{\code{getInsertionSeqs(target)}}{Description:
  Return a table relating insertion sequences to alignment indices
Input parameters:}
}}

\examples{
# readsToTarget with signature("GAlignments", "GRanges") returns a 
# CrisprRun object

bam_fname <- system.file("extdata", "gol_F1_clutch_1_embryo_1_s.bam",
                        package = "CrispRVariants")
param <- Rsamtools::ScanBamParam(what = c("seq", "flag"))
alns <- GenomicAlignments::readGAlignments(bam_fname, param = param, 
         use.names = TRUE)

reference <- Biostrings::DNAString("GGTCTCTCGCAGGATGTTGCTGG")
gd <- GenomicRanges::GRanges("18", IRanges::IRanges(4647377, 4647399), strand = "+")

crispr_run <- readsToTarget(alns, target = gd, reference = reference,
                           name = "Sample name", target.loc = 17)

# Alternatively, CrisprRun objects can be accessed from a CrisprSet object
# e.g. crispr_set$crispr_runs[[1]]
}
\seealso{
\code{\link{CrisprSet}}
}
\author{
Helen Lindsay
}
