% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessors.R
\name{mutationEfficiency}
\alias{mutationEfficiency}
\alias{mutationEfficiency,CrisprSet-method}
\title{Get mutation efficiency}
\usage{
mutationEfficiency(obj, ...)

\S4method{mutationEfficiency}{CrisprSet}(
  obj,
  ...,
  snv = c("non_variant", "include", "exclude"),
  include.chimeras = TRUE,
  exclude.cols = NULL,
  filter.vars = NULL,
  filter.cols = NULL,
  group = NULL
)
}
\arguments{
\item{obj}{An object containing variant counts}

\item{...}{additional arguments}

\item{snv}{Single nucleotide variants (SNVs) may be considered as
mutations ("include"), treated as ambiguous sequences and not counted
at all ("exclude"), or treated as non-mutations, e.g. sequencing errors
or pre-existing SNVs ("non_variant", default)}

\item{include.chimeras}{Should chimeric alignments be counted as variants
when calculating mutation efficiency (Default: TRUE}

\item{exclude.cols}{A vector of names of columns in the variant counts table
that will not be considered when counting mutation efficiency}

\item{filter.vars}{Variants to remove before calculating efficiency.
May be either a variant size, e.g. "1D", or a particular 
variant/variant combination, e.g. -5:3D}

\item{filter.cols}{A vector of control sample names.  Any variants present in the control
samples will be counted as non-variant, unless they also contain another indel.  Note that
this is not compatible with counting snvs as variants.}

\item{group}{A grouping vector.  If provided, efficiency will be calculated
per group (Default: NULL)}
}
\value{
A vector of efficiency statistics per sample and overall, or 
a matrix of efficiency statistics per group if a group is provided
}
\description{
Returns the percentage of sequences that contain at least
one mutation.
}
\examples{
data("gol_clutch1")
mutationEfficiency(gol)
}
\author{
Helen Lindsay
}
