% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initialisers.R
\name{readTargetBam}
\alias{readTargetBam}
\title{Internal CrispRVariants function for reading and filtering a bam file}
\usage{
readTargetBam(
  file,
  target,
  exclude.ranges = GRanges(),
  exclude.names = NA,
  chimera.to.target = 5,
  chimeras = c("count", "ignore", "exclude", "merge"),
  max.read.overlap = 10,
  max.unmapped = 4,
  by.flag = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{file}{The name of a bam file to read in}

\item{target}{A GRanges object containing a single target range}

\item{exclude.ranges}{A GRanges object of regions that should not be counted,
e.g. primer or cloning vector sequences that have a match in the genome}

\item{exclude.names}{A vector of read names to exclude.}

\item{chimera.to.target}{Maximum distance between endpoints of chimeras and
target.loc for assigning chimeras to targets (default: 5)}

\item{chimeras}{Flag to determine how chimeric reads are treated.  One of
"ignore", "exclude", "count" and "merge".  Default "ignore".}

\item{max.read.overlap}{Maximum number of bases mapped to two positions
for chimeras to be merged (Default: 10)}

\item{max.unmapped}{Maximum number of bases that are unmapped for chimeras
to be merged (Default: 4)}

\item{by.flag}{Is the supplementary alignment flag set?  Used for identifying chimeric
alignments, function is much faster if TRUE.  Not all aligners set this flag.  If FALSE,
chimeric alignments are identified using read names (Default: TRUE)}

\item{verbose}{Print stats about number of alignments read and filtered.  (Default: TRUE)}
}
\value{
A GenomicAlignments::GAlignment obj
}
\description{
Includes options for excluding reads either by name or range.
The latter is useful if chimeras are excluded.  Reads are excluded before
chimeras are detected, thus a chimeric read consisting of two sections, one of
which overlaps an excluded region, will not be considered chimeric.
Chimeric reads can be ignored, excluded, which means that all sections of a
chimeric read will be removed, or merged, which means that chimeras will be
collapsed into a single read where possible. (Not implemented yet)
If chimeras = "merge", chimeric reads are merged if all segments
}
